<?php if($my_archive_bookings->count() > 0): ?>
    <div class="table-responsive">
        <table class="table eTable">
            <thead>
                <tr>
                    <th><?php echo e(get_phrase('Subject')); ?></th>
                    <th><?php echo e(get_phrase('Tutor')); ?></th>
                    <th><?php echo e(get_phrase('Time')); ?></th>
                    <th><?php echo e(get_phrase('Amount')); ?></th>
                    <th><?php echo e(get_phrase('Payment Method')); ?></th>
                    <th><?php echo e(get_phrase('Invoice')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $my_archive_bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $my_booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($my_booking->booking_to_schedule->schedule_to_tutorSubjects->name); ?></td>
                        <td><?php echo e($my_booking->booking_to_tutor->name); ?></td>
                        <td><?php echo e(date('h:i a', $my_booking->start_time) . ' - ' . date('h:i a', $my_booking->end_time)); ?></td>
                        <td><?php echo e(currency($my_booking->booking_to_schedule->schedule_to_tutorCanteach->price)); ?></td>
                        <td><?php echo e(get_phrase('Stripe')); ?></td>
                        <td>
                            <a href="<?php echo e(route('booking_invoice', $my_booking->id)); ?>"
                                class="d-flex align-items-center justify-content-center btn btn-primary text-18 text-white py-3" data-bs-toggle="tooltip" data-bs-title="<?php echo e(get_phrase('Print Invoice')); ?>">
                                <i class="fi fi-rr-print d-inline-flex"></i>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
<?php else: ?>
    <div class="row bg-white radius-10 mx-2">
        <div class="com-md-12">
            <?php echo $__env->make('frontend.default.empty', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
<?php endif; ?>

<!-- Pagination -->
<?php if(count($my_archive_bookings) > 0): ?>
<div class="entry-pagination">
    <nav aria-label="Page navigation example">
        <?php echo e($my_archive_bookings->appends(['tab' => 'archive'])->links()); ?>

    </nav>
</div>
<?php endif; ?>
<!-- Pagination --><?php /**PATH /var/www/html/vityarthi.com/resources/views/frontend/default/student/my_bookings/archive.blade.php ENDPATH**/ ?>