<?php $__env->startPush('title', get_phrase('Instructor details')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?><?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <style>
        .eBar-card .courses-img img {
            height: 221px !important;
        }
    </style>
    <!------------------- Breadcum Area Start  ------>
    <section class="instructor-details">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="eNtry-breadcum">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(get_phrase('Home')); ?></a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php echo e(get_phrase('Instructor Details')); ?>

                                </li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!------------------- Breadcum Area End  --------->
    <!-------------- List Item Start   --------------->
    <section class="instructor-wrapper">
        <div class="container">
            <div class="single-details">
                <div class="row">
                    <div class="col-lg-5 col-md-5">
                        <div class="left-profile">
                            <div class="instruct-img">
                                <div class="instructor-photo">
                                    <img src="<?php echo e(get_image($instructor_details->photo)); ?>" alt="instructor-photo">
                                </div>
                            </div>
                            <div class="btn-wrap">
                                <a href="javascript: void(0);" class="eBtn learn-btn">
                                    <?php echo e(count_student_by_instructor($instructor_details->id)); ?>

                                </a>
                                <a href="javascript: void(0);" class="eBtn gradient">
                                    <?php echo e(count_course_by_instructor($instructor_details->id)); ?>

                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-7 col-md-7">
                        <div class="right-profile">
                            <h3 class="g-title"><?php echo e(get_phrase('Hi, I’m')); ?> <?php echo e($instructor_details->name); ?></h3>
                            <span class="gradient color shadow-none"><?php echo e($instructor_details->skill); ?></span>
                            <p class="description"><?php echo e($instructor_details->boigraphy); ?></p>
                            <ul class="instruct-add">
                                <li>
                                    <p><?php echo e(get_phrase('Experience')); ?></p>
                                    <span>: <?php echo e(instructor_experience($instructor_details->id)); ?></span>
                                </li>
                                <?php if($instructor_details->email): ?>
                                    <li>
                                        <p><?php echo e(get_phrase('Email')); ?></p><span>: <?php echo e($instructor_details->email); ?></span>
                                    </li>
                                <?php endif; ?>
                                <?php if($instructor_details->phone): ?>
                                    <li>
                                        <p><?php echo e(get_phrase('Phone')); ?></p><span>: <?php echo e($instructor_details->phone); ?></span>
                                    </li>
                                <?php endif; ?>
                                <?php if($instructor_details->details): ?>
                                    <li>
                                        <p><?php echo e(get_phrase('Location')); ?></p><span>:
                                            <?php echo e($instructor_details->details); ?></span>
                                    </li>
                                <?php endif; ?>
                            </ul>
                            <ul class="f-socials d-flex">
                                <li>
                                    <a href="<?php echo e($instructor_details->twitter ?? 'javascript: void(0);'); ?>">
                                        <i class="fa-brands fa-twitter"></i>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e($instructor_details->facebook ?? 'javascript: void(0);'); ?>">
                                        <i class="fa-brands fa-facebook-f"></i>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e($instructor_details->linkedin ?? 'javascript: void(0);'); ?>">
                                        <i class="fa-brands fa-linkedin-in"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="group-overly">
                    <span><img class="top-overly" src="<?php echo e(asset('assets/frontend/default/image/top-overly.png')); ?>"
                            alt="..."></span>
                    <span><img class="bottom-overly" src="<?php echo e(asset('assets/frontend/default/image/bottom.png')); ?>"
                            alt="..."></span>
                </div>
            </div>
        </div>
    </section>
    <!-------------- List Item End  --------------->
    <!-------------- My Course Item Start  --------------->
    <?php if(count($instructor_courses) > 0): ?>
        <section class="feature-wrapper section-padding">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="res-control d-flex align-items-center justify-content-between">
                            <div class="section-title mb-0">
                                <h2 class="title"><?php echo e(get_phrase('My Courses')); ?></h2>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center mt-50">
                    <?php $__currentLoopData = $instructor_courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo $__env->make('frontend.default.course.course_grid', ['course' => $course], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <!-- Pagination -->
                <div class="entry-pagination">
                    <nav aria-label="Page navigation example">
                        <?php echo e($instructor_courses->links()); ?>

                    </nav>
                </div>
                <!-- Pagination -->
            </div>
        </section>
    <?php endif; ?>
    <!-------------- My Course  Item End  --------------->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/vityarthi.com/resources/views/frontend/default/instructor/details.blade.php ENDPATH**/ ?>