<?php
    $page_data = $data['page_data'];
    $payment_details = $data['payment_details'];
    $color = $data['color'];
    $payment_gateway = DB::table('payment_gateways')->where('identifier', 'razorpay')->first();
?>

<button id="rzp-button1" hidden><?php echo e(get_phrase('Pay')); ?></button>

<form action="<?php echo e(route('payment.success', ['identifier' => 'razorpay'])); ?>" hidden>
    <?php echo csrf_field(); ?>
    <input type="text" name="razorpay_payment_id" id="razorpay_payment_id">
    <input type="text" name="razorpay_order_id" id="razorpay_order_id">
    <input type="text" name="razorpay_signature" id="razorpay_signature">
    <input type="submit" id="payment_done">
</form>

<script src="<?php echo e(asset('assets/frontend/default/js/jquery-3.7.1.min.js')); ?>"></script>
<script src="https://checkout.razorpay.com/v1/checkout.js"></script>
<script>
    "use strict";

    var color = "<?php echo e($color); ?>";

    var options = {
        "key": "<?php echo e($page_data['razorpay_id']); ?>",
        "amount": "<?php echo e($page_data['amount']); ?>",
        "currency": "<?php echo e($payment_gateway->currency); ?>",

        "name": "<?php echo e($page_data['name']); ?>",
        "description": "<?php echo e($page_data['description']); ?>",
        "image": "<?php echo e(get_image(auth()->user()->photo)); ?>",

        "order_id": "<?php echo e($page_data['order_id']); ?>",

        "handler": function(response) {
            var razorpay_payment_id = response.razorpay_payment_id;
            var razorpay_order_id = response.razorpay_order_id;
            var razorpay_signature = response.razorpay_signature;
            window.location.href = "<?php echo e($payment_details['success_url'] . '/' . $payment_gateway->identifier); ?>?razorpay_payment_id=" + response.razorpay_payment_id;
        },

        "prefill": {
            "name": "<?php echo e($page_data['name']); ?>",
            "email": "<?php echo e($page_data['email']); ?>",
            "contact": "<?php echo e($page_data['phone']); ?>"
        },
        "notes": {
            "address": "<?php echo e($page_data['name']); ?>"
        },
        "theme": {
            "color": color
        }
    };
    var rzp1 = new Razorpay(options);
    rzp1.on('payment.failed', function(response) {
        alert(response.error.description);
        alert(response.error.reason);
    });
    document.getElementById('rzp-button1').onclick = function(e) {
        rzp1.open();
        e.preventDefault();
    }

    $(document).ready(function() {
        $('#rzp-button1').trigger('click');
    });
</script>
<?php /**PATH /var/www/html/vityarthi.com/resources/views/payment/razorpay/payment.blade.php ENDPATH**/ ?>