<?php
    $replies = App\Models\Forum::join('users', 'forums.user_id', 'users.id')
        ->select('forums.*', 'users.name as user_name', 'users.photo as user_photo')
        ->latest('forums.id')
        ->where('forums.parent_id', $question->id)
        ->get();
?>
<div class="child-review ps-5">
    <?php $__currentLoopData = $replies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="child-review mb-3">
            <div class="user">
                <div class="image">
                    <img src="<?php echo e(get_image($child->user_photo)); ?>">
                </div>
                <h1 class="w-100 d-flex flex-column">
                    <span><?php echo e($child->user_name); ?></span>
                    <small><?php echo e(timeAgo($child->created_at)); ?></small>

                </h1>

                <?php if($child->user_id == auth()->user()->id): ?>
                    <div class="d-flex gap-3">
                        <a href="javascript:void(0)" class="show-form" id="reply-edit" data-reply-id="<?php echo e($child->id); ?>">
                            <div class="edit edit">
                                <i class="fi fi-rr-edit d-inline-flex"></i>
                            </div>
                        </a>

                        <a href="<?php echo e(route('forum.question.delete', $child->id)); ?>">
                            <i class="fi fi-rr-trash d-inline-flex"></i></a>
                    </div>
                <?php endif; ?>
            </div>
            <div class="">
                <p><?php echo e(strip_tags($child->description)); ?></p>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<?php /**PATH /var/www/html/vityarthi.com/resources/views/course_player/forum/child_review.blade.php ENDPATH**/ ?>