<style>
    .select2-selection.select2-selection--multiple {
        cursor: pointer !important;
    }
</style>

<form class="ajaxForm" action="<?php echo e(route('admin.course.question.store')); ?>" method="post"><?php echo csrf_field(); ?>

    <input type="hidden" name="quiz_id" value="<?php echo e($id); ?>">
    <div class="row">
        <div class="col-sm-12">
            <div class="mb-3">
                <label class="form-label ol-form-label">
                    <?php echo e(get_phrase('Question Type')); ?>

                    <span class="text-danger ms-1">*</span>
                </label>
                <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="type"
                    onchange="getOptionType(this)">
                    <option value=""><?php echo e(get_phrase('Select an option')); ?></option>
                    <option value="mcq"><?php echo e(get_phrase('Multiple Choice')); ?></option>
                    <option value="fill_blanks"><?php echo e(get_phrase('Fill in the blanks')); ?></option>
                    <option value="true_false"><?php echo e(get_phrase('True or False')); ?></option>
                </select>
            </div>
        </div>
    </div>

    <div class="fpb-7 mb-3">
        <label for="title" class="form-label ol-form-label">
            <?php echo e(get_phrase('Write question')); ?>

            <span class="text-danger ms-1">*</span>
        </label>
        <textarea name="title" rows="5" class="form-control ol-form-control text_editor"></textarea>
    </div>

    <div class="load-question-type"></div>

    <div class="d-flex gap-3">
        <a href="#" class="btn ol-btn-primary" id="questionBackBtn"
            onclick="ajaxModal('<?php echo e(route('modal', ['admin.questions.index', 'id' => $id])); ?>', '<?php echo e(get_phrase('Questions')); ?>', 'modal-lg')">
            <i class="fi-rr-angle-small-left"></i> <?php echo e(get_phrase('Back')); ?>

        </a>

        <div class="fpb7">
            <button type="submit" class="btn ol-btn-primary"><?php echo e(get_phrase('Add Question')); ?></button>
        </div>
    </div>
</form>


<?php echo $__env->make('admin.init', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
    function getOptionType(elem) {
        let type = elem.value;
        setupQuestion(type)
    }

    function setupQuestion(type) {
        if (type) {
            $.ajax({
                type: "get",
                url: "<?php echo e(route('admin.load.question.type')); ?>",
                data: {
                    type: type
                },
                success: function(response) {
                    $('.load-question-type').empty().append(response)
                }
            });
        }
    }

    // after response this function will call
    function responseBack() {
        document.querySelector('#questionBackBtn').click();
    }
</script>
<?php /**PATH /var/www/html/vityarthi.com/resources/views/admin/questions/create.blade.php ENDPATH**/ ?>