<?php $__env->startPush('title', get_phrase('Invoice')); ?>

<?php $__env->startSection('content'); ?>
    <section class="wishlist-content">
        <div class="profile-banner-area"></div>
        <div class="container profile-banner-area-container">
            <div class="row">
                <?php echo $__env->make('frontend.default.student.left_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="col-lg-9">
                    <h4 class="g-title mb-5"><?php echo e(get_phrase('Invoice')); ?></h4>
                    <div class="my-panel purchase-history-panel">
                        <div class="invoice mt-5" id="invoice">
                            <div class="top d-flex justify-content-between align-items-center pb-5 mb-5 border-1 border-bottom">
                                <div>
                                    <h2>
                                        <span><?php echo e(get_phrase('Invoice')); ?></span>
                                        <span>#<?php echo e(str_pad($invoice->id, 5, '0', STR_PAD_LEFT)); ?></span>
                                    </h2>
                                    <p class="description">
                                        <?php echo e(get_phrase('Date')); ?>:
                                        <?php echo e(date('d-m-Y', strtotime($invoice->created_at))); ?>

                                    </p>
                                </div>
                                <div>
                                    <img src="<?php echo e(get_image(get_frontend_settings('dark_logo'))); ?>" alt="system logo" class="object-fit-cover rounded" width="200px">
                                </div>
                            </div>

                            <div class="billing-area">
                                <div class="table-responsive">
                                    <table class="table eTable">
                                        <thead>
                                            <tr>
                                                <th><?php echo e(get_phrase('Item')); ?></th>
                                                <th><?php echo e(get_phrase('Date of issue')); ?></th>
                                                <th><?php echo e(get_phrase('Payment Method')); ?></th>
                                                <th><?php echo e(get_phrase('Price')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <p>
                                                        <?php echo e($invoice->course_title); ?>

                                                    </p>
                                                </td>
                                                <td>
                                                    <p><?php echo e(date('d-m-Y', strtotime($invoice->created_at))); ?></p>
                                                </td>
                                                <td>
                                                    <p><?php echo e(ucfirst($invoice->payment_type)); ?></p>
                                                </td>
                                                <td width="110px">
                                                    <p><?php echo e(currency($invoice->amount, 2)); ?></p>
                                                </td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="description"><?php echo e(get_phrase('Billed to :')); ?></p>
                                                </td>
                                                <td>
                                                    <p class="description"><?php echo e(auth()->user()->name); ?></p>
                                                </td>
                                                <td>
                                                    <p class="description text-dark"><?php echo e(get_phrase('Total')); ?></p>
                                                </td>
                                                <td width="110px">
                                                    <p><?php echo e(currency($invoice->amount, 2)); ?></p>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex align-items-center justify-content-end gap-3 mt-3">
                        <a class="eBtn gradient" href="<?php echo e(route('purchase.history')); ?>"><?php echo e(get_phrase('Back')); ?></a>
                        <a class="eBtn gradient" id="print" href="javascript:void(0);" onclick="printableDiv('invoice')"><?php echo e(get_phrase('Print')); ?></a>
                    </div>
                </div>


            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        "use strict";

        function printableDiv(printableAreaDivId) {
            var printContents = document.getElementById(printableAreaDivId).innerHTML;
            var originalContents = document.body.innerHTML;
            document.body.innerHTML = printContents;
            window.print();
            document.body.innerHTML = originalContents;
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/vityarthi.com/resources/views/frontend/default/student/purchase_history/invoice.blade.php ENDPATH**/ ?>