<?php
    $sections = App\Models\Section::where('course_id', $id)->orderBy('sort')->get();
?>

<div class="alert alert-primary ol-alert-primary ol-alert-sm mb-3" role="alert">
    <p class="title2 fs-14px d-flex align-items-center"><?php echo e(get_phrase('Lesson type')); ?>:
        <?php if($lesson_type == 'html5'): ?>
            <?php echo e(get_phrase('Video url') . ' [.mp4]'); ?>

        <?php elseif($lesson_type == 'video'): ?>
            <?php echo e(get_phrase('Video file')); ?>

        <?php elseif($lesson_type == 'youtube' || $lesson_type == 'academy cloud' || $lesson_type == 'vimeo'): ?>
            <?php echo e(ucfirst(get_phrase($lesson_type))); ?> <?php echo e(get_phrase('Video')); ?>

        <?php elseif($lesson_type == 'google_drive_video'): ?>
            <?php echo e(get_phrase('Google drive video')); ?>

        <?php elseif($lesson_type == 'document'): ?>
            <?php echo e(get_phrase('Document file')); ?>

        <?php else: ?>
            <?php echo e(ucfirst($lesson_type)); ?>

        <?php endif; ?>
        <a onclick="ajaxModal('<?php echo e(route('modal', ['admin.course.lesson_type', 'id' => $id])); ?>', '<?php echo e(get_phrase('Sort sections')); ?>')"
            class="btn text-primary ms-auto p-0 text-14px" href="javascript:void(0)"><?php echo e(get_phrase('Change')); ?> <i
                class="fi-rr-arrow-alt-circle-right"></i></a>
    </p>
</div>

<!-- ACTUAL LESSON ADDING FORM -->
<form class="ajaxFormSubmission" action="<?php echo e(route('admin.lesson.store')); ?>" method="post" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>

    <input type="hidden" name="course_id" value="<?php echo e($id); ?>">
    <input type="hidden" name="lesson_type" value="<?php echo e($lesson_type); ?>">
    <div class="form-group mb-3">
        <label class="form-label ol-form-label"><?php echo e(get_phrase('Title')); ?></label>
        <input type="text" name="title" class="form-control ol-form-control" required>
    </div>

    <div class="form-group mb-3">
        <label class="form-label ol-form-label"><?php echo e(get_phrase('Section')); ?></label>
        <select class="form-control ol-select2" data-toggle="select2" name="section_id" required>
            <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($section->id); ?>"><?php echo e($section->title); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <?php if($lesson_type == 'youtube'): ?>
        <?php echo $__env->make('admin.course.youtube_type_lesson_add', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($lesson_type == 'academy_cloud'): ?>
        <?php echo $__env->make('admin.course.academy_cloud_type_lesson_add', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($lesson_type == 'vimeo'): ?>
        <?php echo $__env->make('admin.course.vimeo_type_lesson_add', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($lesson_type == 'html5'): ?>
        <?php echo $__env->make('admin.course.html5_type_lesson_add', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($lesson_type == 'video'): ?>
        <?php echo $__env->make('admin.course.video_type_lesson_add', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($lesson_type == 'amazon-s3'): ?>
        <?php echo $__env->make('amazon_s3_type_lesson_add.php', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($lesson_type == 'google_drive_video'): ?>
        <?php echo $__env->make('admin.course.google_drive_type_lesson_add', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($lesson_type == 'document'): ?>
        <?php echo $__env->make('admin.course.document_type_lesson_add', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($lesson_type == 'text'): ?>
        <?php echo $__env->make('admin.course.text_type_lesson_add', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($lesson_type == 'image'): ?>
        <?php echo $__env->make('admin.course.image_file_type_lesson_add', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($lesson_type == 'iframe'): ?>
        <?php echo $__env->make('admin.course.iframe_type_lesson_add', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <div class="form-group mb-3">
        <label class="form-label ol-form-label"><?php echo e(get_phrase('Summary')); ?></label>
        <textarea name="summary" class="form-control text_editor"></textarea>

    </div>


    <div class="form-group mb-3 d-none">
        <label class="form-label ol-form-label"><?php echo e(get_phrase('Do you want to keep it free as a preview lesson')); ?>

            ?</label>
        <br>
        <input type="checkbox" name="free_lesson" id="free_lesson" value="1" class="form-check-input">
        <label for="free_lesson"><?php echo e(get_phrase('Mark as free lesson')); ?></label>
    </div>

    <div class="text-center">
        <button class="btn ol-btn-primary ol-btn-sm w-100 formSubmissionBtn" type="submit"
            name="button"><?php echo e(get_phrase('Add lesson')); ?></button>
    </div>
</form>

<script>
    'use strict';

    function ajax_get_video_details(url) {
        $('#perloader').show();
        if (checkURLValidity(url)) {
            $.ajax({
                url: "<?php echo e(route('get.video.details')); ?>",
                type: 'POST',
                data: {
                    url: url
                },
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                success: function(response) {
                    console.log(response);
                    jQuery('#duration').val(response.duration);
                    $('#perloader').hide();
                    $('#invalid_url').hide();
                }
            });
        } else {
            $('#invalid_url').show();
            $('#perloader').hide();
            jQuery('#duration').val('');

        }
    }

    function checkURLValidity(video_url) {
        var youtubePregMatch =
            /^(?:https?:\/\/)?(?:www\.)?(?:youtu\.be\/|youtube\.com\/(?:embed\/|v\/|watch\?v=|watch\?.+&v=))((\w|-){11})(?:\S+)?$/;
        var vimeoPregMatch = /^(http\:\/\/|https\:\/\/)?(www\.)?(vimeo\.com\/)([0-9]+)$/;
        if (video_url.match(youtubePregMatch)) {
            return true;
        } else if (vimeoPregMatch.test(video_url)) {
            return true;
        } else {
            return false;
        }
    }
</script>
<?php echo $__env->make('admin.init', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /var/www/html/vityarthi.com/resources/views/admin/course/lesson_add.blade.php ENDPATH**/ ?>