<?php
    $sections = App\Models\Section::where('course_id', $course_details->id)
        ->orderBy('sort')
        ->get();

    $completed_lesson = json_decode(
        App\Models\Watch_history::where('course_id', $course_details->id)
            ->where('student_id', Auth()->user()->id)
            ->value('completed_lesson'),
        true,
    ) ?? [];
    $active_section = App\Models\Lesson::where('id', $history->watching_lesson_id ?? '')->value('section_id');

    $lesson_history = App\Models\Watch_history::where('course_id', $course_details->id)
        ->where('student_id', auth()->user()->id)
        ->firstOrNew();
    $completed_lesson_arr = json_decode($lesson_history->completed_lesson, true);
    $complated_lesson = is_array($completed_lesson_arr) ? count($completed_lesson_arr) : 0;
    $course_progress_out_of_100 = progress_bar($course_details->id);

    $user_id = Auth()->user()->id;
    $is_course_instructor = is_course_instructor($course_details->id, $user_id);

    $is_locked = 0;
    $locked_lesson_ids = array();
?>

<style>
    .checkbox-icon {
        color: #2c3370;
    }
</style>

<div class="course-content-playlist">
    <div class="row border-bottom pb-3">
        <div class="col-md-12">
            <h1 class="heading mb-2"><?php echo e(get_phrase('Course curriculum')); ?></h1>
            <p class="info text-14px text-center mb-1"><?php echo e($course_progress_out_of_100); ?>% <?php echo e(get_phrase('Completed')); ?>

                (<?php echo e($complated_lesson); ?>/<?php echo e(lesson_count($course_details->id)); ?>)
            </p>
        </div>
    </div>

    <div class="course-playlist-accordion">
        <div class="accordion" id="coursePlay">
            <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $lessons = App\Models\Lesson::where('section_id', $section->id)
                        ->orderBy('sort')
                        ->get();
                ?>
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button <?php if($active_section != $section->id): ?> collapsed <?php endif; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse_<?php echo e($section->id); ?>" aria-expanded="<?php if($section->id != $active_section): ?> false <?php else: ?> true <?php endif; ?>" aria-controls="collapse_<?php echo e($section->id); ?>">
                            <?php echo e(ucfirst($section->title)); ?>

                        </button>
                    </h2>
                    <div id="collapse_<?php echo e($section->id); ?>" class="accordion-collapse collapse <?php if($section->id == $active_section): ?> show <?php endif; ?>" data-bs-parent="#coursePlay">
                        <div class="accordion-body">
                            <ul class="coourse-playlist-list">
                                <?php $__currentLoopData = $lessons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $type = $lesson->lesson_type; ?>
                                    <li class="coourse-playlist-item <?php if(isset($history->watching_lesson_id) && $lesson->id == $history->watching_lesson_id): ?> active <?php else: ?> lock <?php endif; ?>">
                                        <div class="check-title-area align-items-center">
                                            <?php if($course_details->enable_drip_content): ?>
                                                <?php if($is_locked): ?>
                                                    <i class="fas fa-lock" title="<?php echo get_phrase('Complete previous lesson to unlock it'); ?>" data-bs-toggle="tooltip"></i>
                                                <?php else: ?>
                                                    <?php if(in_array($lesson->id, $completed_lesson_arr)): ?>
                                                        <i class="fas fa-check-circle checkbox-icon" title="<?php echo get_phrase('Lesson completed'); ?>"></i>
                                                    <?php elseif(in_array($type, ['video-url', 'system-video', 'vimeo-url', 'google_drive'])): ?>
                                                        <i class="form-check-input flexCheckChecked mt-0" title="<?php echo get_phrase('Play Now'); ?>"></i>
                                                    <?php else: ?>
                                                        <input class="form-check-input flexCheckChecked mt-0" <?php if(in_array($lesson->id, $completed_lesson)): ?> checked <?php endif; ?> type="checkbox" id="<?php echo e($lesson->id); ?>">
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                                <div class="play-lock-number">
                                                    <span>
                                                        <?php if(in_array($type, ['text', 'document_type', 'iframe'])): ?>
                                                            <i class="fa-solid fa-file"></i>
                                                        <?php elseif(in_array($type, ['video-url', 'system-video', 'vimeo-url'])): ?>
                                                            <i class="fa-solid fa-video"></i>
                                                        <?php elseif($type == 'image'): ?>
                                                            <i class="fa-solid fa-image"></i>
                                                        <?php elseif($type == 'google_drive'): ?>
                                                            <i class="fa-brands fa-google-drive"></i>
                                                        <?php else: ?>
                                                            <i class="fa-solid fa-file"></i>
                                                        <?php endif; ?>
                                                    </span>
                                                </div>
                                                <p class="d-none"><?php echo e($lesson->lesson_type); ?></p>
                                                <a href="<?php echo e(route('course.player', ['slug' => $course_details->slug, 'id' => $lesson->id])); ?>" class="video-title"><?php echo e($lesson->title); ?></a>
                                            <?php else: ?>
                                                <input class="form-check-input flexCheckChecked mt-0" <?php if(in_array($lesson->id, $completed_lesson)): ?> checked <?php endif; ?> type="checkbox" id="<?php echo e($lesson->id); ?>">
                                                <div class="play-lock-number">
                                                    <?php $type = $lesson->lesson_type; ?>
                                                    <span>
                                                        <?php if(in_array($type, ['text', 'document_type', 'iframe'])): ?>
                                                            <i class="fa-solid fa-file"></i>
                                                        <?php elseif(in_array($type, ['video-url', 'system-video', 'vimeo-url'])): ?>
                                                            <i class="fa-solid fa-video"></i>
                                                        <?php elseif($type == 'image'): ?>
                                                            <i class="fa-solid fa-image"></i>
                                                        <?php elseif($type == 'google_drive'): ?>
                                                            <i class="fa-brands fa-google-drive"></i>
                                                        <?php else: ?>
                                                            <i class="fa-solid fa-file"></i>
                                                        <?php endif; ?>
                                                    </span>
                                                </div>
                                                <p class="d-none"><?php echo e($lesson->lesson_type); ?></p>
                                                <a href="<?php echo e(route('course.player', ['slug' => $course_details->slug, 'id' => $lesson->id])); ?>" class="video-title"><?php echo e($lesson->title); ?></a>
                                            <?php endif; ?>
                                        </div>

                                        <?php if(lesson_durations($lesson->id) != '00:00:00'): ?>
                                            <p class="duration"><?php echo e(lesson_durations($lesson->id)); ?></p>
                                        <?php endif; ?>
                                    </li>
                                    <?php
                                        if ($is_locked) {
                                            $locked_lesson_ids[] = $lesson->id;
                                        }

                                        if (
                                            !in_array($lesson->id, $completed_lesson_arr) &&
                                            !$is_locked &&
                                            $course_details->enable_drip_content == 1 &&
                                            auth()->user() &&  // Lowercase 'auth()' for consistency
                                            !$is_course_instructor
                                        ) {
                                            $is_locked = 1;
                                        }
                                    ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>

<form class="ajaxForm" action="<?php echo e(route('set.watch.history')); ?>" method="post" id="watch_history_form">
    <?php echo csrf_field(); ?>
    <input type="hidden" class="course_id" name="course_id" value="<?php echo e($course_details->id); ?>">
    <input type="hidden" class="lesson_id" name="lesson_id">
</form>
<?php /**PATH /var/www/html/vityarthi.com/resources/views/course_player/side_bar.blade.php ENDPATH**/ ?>