



<section class="blog-wrapper section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="res-control d-flex align-items-center justify-content-between">
                    <div class="section-title mb-0">
                        <span class="title-head mb-10 builder-editable" builder-identity="1"><?php echo e(get_phrase('Our Blog')); ?></span>
                        <h2 class="title builder-editable" builder-identity="2"><?php echo e(get_phrase('Have a look on our news')); ?></h2>
                    </div>
                    <span class="blog-view-all-button">
                        <a href="<?php echo e(route('blogs')); ?>" class="eBtn gradient builder-editable" builder-identity="3"><?php echo e(get_phrase('View All Blogs')); ?></a>
                    </span>
                </div>
            </div>
        </div>
        <?php
            $blogs = App\Models\Blog::where('status', 1)->orderBy('is_popular', 'desc')->orderBy('id', 'desc')->take(3)->get();
        ?>
        <div class="row justify-content-center mt-50">
            <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6 col-sm-6 mb-20">
                    <div class="Ecard card b-card">
                        <div class="card-head">
                            <img src="<?php echo e(get_image($blog->thumbnail)); ?>" alt="blog-thumbnail">
                            <span><?php echo e(get_blog_category_name($blog->category_id)); ?></span>
                        </div>
                        <div class="card-body">
                            <h4><?php echo e(ucfirst($blog->title)); ?></h4>
                            <div class="description ellipsis-line-2 mt-3">
                                <?php echo e(ellipsis(strip_tags($blog->description), 160)); ?>

                            </div>
                            <p></p>
                            <div class="b_bottom d-flex justify-content-between">
                                <a href="<?php echo e(route('blog.details', $blog->slug)); ?>" class="read-text mt-0 stretched-link"><?php echo e(get_phrase('Read More')); ?><i class="fa-solid fa-arrow-right-long ms-2"></i></a>
                                <span><?php echo e(date('d M, Y', strtotime($blog->created_at))); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

    </div>
</section>
<?php /**PATH /var/www/html/vityarthi.com/resources/views/components/home_made_by_developer/blog.blade.php ENDPATH**/ ?>