<?php
    $lessons = App\Models\Lesson::where('id', $id)->first();
    $sections = App\Models\Section::where('course_id', $lessons->course_id)
        ->orderBy('sort')
        ->get();
    $select_section = App\Models\Section::where('id', $lessons->section_id)->value('title');
?>

<div class="alert alert-info d-flex align-items-center py-2" role="alert">
    <?php echo e(get_phrase('Lesson type')); ?>:
    <?php if($lessons->lesson_type == 'html5'): ?>
        <strong class="text-capitalize ms-1"><?php echo e(get_phrase('Video url') . ' [.mp4]'); ?></strong>
    <?php elseif($lessons->lesson_type == 'system-video'): ?>
        <strong class="text-capitalize ms-1"><?php echo e(get_phrase('Video file')); ?></strong>
    <?php elseif($lessons->video_type == 'youtube' || $lessons->video_type == 'vimeo'): ?>
        <strong class="text-capitalize ms-1"><?php echo e(get_phrase($lessons->video_type)); ?> <?php echo e(get_phrase('Video')); ?> </strong>
    <?php elseif($lessons->lesson_type == 'google_drive_video'): ?>
        <strong class="text-capitalize ms-1"><?php echo e(get_phrase('Google drive video')); ?></strong>
    <?php elseif($lessons->lesson_type == 'document_type'): ?>
        <strong class="text-capitalize ms-1"><?php echo e(get_phrase('Document file')); ?></strong>
    <?php else: ?>
        <strong class="text-capitalize ms-1"><?php echo e($lessons->lesson_type); ?></strong>
    <?php endif; ?>
</div>

<!-- ACTUAL LESSON ADDING FORM -->
<form class="ajaxFormSubmission" action="<?php echo e(route('admin.lesson.edit')); ?>" method="post" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>

    <input type="hidden" name="id" value="<?php echo e($id); ?>">
    <input type="hidden" name="lesson_type" value="<?php echo e($lessons->lesson_type); ?>">
    <div class="form-group eForm-group mb-2">
        <label class="form-label ol-form-label"><?php echo e(get_phrase('Title')); ?></label>
        <input type="text" name="title" class="form-control ol-form-control" value="<?php echo e($lessons->title); ?>" required>
    </div>

    <div class="form-group mb-2">
        <label class="form-label ol-form-label"><?php echo e(get_phrase('Section')); ?></label>
        <select class="form-control ol-select2" data-toggle="select2" name="section_id" required>
            <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($section->id); ?>" <?php if($lessons->section_id == $section->id): ?> selected <?php endif; ?>>
                    <?php echo e($section->title); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <?php if($lessons->lesson_type == 'video-url'): ?>
        <?php echo $__env->make('admin.course.youtube_type_lesson_edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($lessons->lesson_type == 'vimeo-url'): ?>
        <?php echo $__env->make('admin.course.vimeo_type_lesson_edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($lessons->lesson_type == 'system-video'): ?>
        <?php echo $__env->make('admin.course.video_type_lesson_edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($lessons->lesson_type == 'html5'): ?>
        <?php echo $__env->make('admin.course.html5_type_lesson_edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($lessons->lesson_type == 'google_drive'): ?>
        <?php echo $__env->make('admin.course.google_drive_type_lesson_edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($lessons->lesson_type == 'document_type'): ?>
        <?php echo $__env->make('admin.course.document_type_lesson_edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($lessons->lesson_type == 'text'): ?>
        <?php echo $__env->make('admin.course.text_type_lesson_edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($lessons->lesson_type == 'image'): ?>
        <?php echo $__env->make('admin.course.image_file_type_lesson_edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($lessons->lesson_type == 'iframe'): ?>
        <?php echo $__env->make('admin.course.iframe_type_lesson_edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <div class="form-group mb-2">
        <label class="form-label ol-form-label"><?php echo e(get_phrase('summary')); ?></label>
        <textarea name="summary" class="form-control text_editor"><?php echo e($lessons->summary); ?></textarea>
    </div>

    <div class="form-group mb-2 d-none">
        <label class="form-label ol-form-label"><?php echo e(get_phrase('Do you want to keep it free as a preview lesson')); ?> ?</label>
        <br>
        <input type="checkbox" name="free_lesson" id="free_lesson" value="1">
        <label for="free_lesson"><?php echo e(get_phrase('Mark as free lesson')); ?></label>
    </div>

    <div class="text-center">
        <button class="btn ol-btn-primary ol-btn-sm w-100 formSubmissionBtn" type="submit"
            name="button"><?php echo e(get_phrase('Update lesson')); ?></button>
    </div>
</form>

<script>
    'use strict';

    function ajax_get_video_details(url) {
        $('#perloader').show();
        if (checkURLValidity(url)) {
            $.ajax({
                url: "<?php echo e(route('get.video.details')); ?>",
                type: 'POST',
                data: {
                    url: url
                },
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                success: function(response) {
                    console.log(response);
                    jQuery('#duration').val(response.duration);
                    $('#perloader').hide();
                    $('#invalid_url').hide();
                }
            });
        } else {
            $('#invalid_url').show();
            $('#perloader').hide();
            jQuery('#duration').val('');

        }
    }

    function checkURLValidity(video_url) {
        var youtubePregMatch =
            /^(?:https?:\/\/)?(?:www\.)?(?:youtu\.be\/|youtube\.com\/(?:embed\/|v\/|watch\?v=|watch\?.+&v=))((\w|-){11})(?:\S+)?$/;
        var vimeoPregMatch = /^(http\:\/\/|https\:\/\/)?(www\.)?(vimeo\.com\/)([0-9]+)$/;
        if (video_url.match(youtubePregMatch)) {
            return true;
        } else if (vimeoPregMatch.test(video_url)) {
            return true;
        } else {
            return false;
        }
    }
</script>

<?php echo $__env->make('admin.init', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /var/www/html/vityarthi.com/resources/views/admin/course/lesson_edit.blade.php ENDPATH**/ ?>