<div class="sidebar">
    <div class="row mb-4">
        <div class="col-6">
            <span class="d-inline-block py-1"><?php echo e(get_phrase('Filter')); ?></span>
        </div>
        <div class="col-6 text-end">
            <?php if(count(request()->all()) > 0 || !empty($category_details)): ?>
            <a class="btn d-flex align-items-center float-end border py-2" href="<?php echo e(route('courses')); ?>"><i class="fi-rr-cross-circle me-2"></i> <span><?php echo e(get_phrase('Clear')); ?> <?php if(isset($_GET) && count($_GET) > 0): ?>(<?php echo e(count($_GET)); ?>)<?php endif; ?></span></a>
            <?php endif; ?>
        </div>
    </div>
    <form class="mb-4" action="<?php echo e(route('courses')); ?>" method="get">
        <div class="widget">
            <div class="search">
                <input type="text" class="form-control" name="search" placeholder="<?php echo e(get_phrase('Search...')); ?>"
                    <?php if(request()->has('search')): ?> value="<?php echo e(request()->input('search')); ?>" <?php endif; ?>>
                <button type="submit" class="submit"><i class="fa-solid fa-magnifying-glass"></i></button>
            </div>
        </div>
    </form>


    <!------------------- categories start ------------------->
    <div class="widget overlay-content overlay-content-max-h-400">
        <h4 class="widget-title"><?php echo e(get_phrase('Categories')); ?></h4>
        <ul class="entry-widget overflow-hidden" id="parent-category">
            <?php
                $parent_categories = App\Models\Category::where('parent_id', 0)->get();
                $active_category = request()->route()->parameter('category');
                $route_queries = request()->query();
                $route_queries = collect($route_queries)->except('page')->all();
            ?>
            <?php $__currentLoopData = $parent_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $route_queries['category'] = $parent_category->slug; ?>

                <li class="category <?php if($parent_category->slug == $active_category): ?> active <?php endif; ?>" id="<?php echo e($parent_category->slug); ?>">
                    <a href="<?php echo e(route('courses', $route_queries)); ?>"
                        class="d-flex align-items-center justify-content-between">
                        <span><?php echo e($parent_category->title); ?></span>
                        <span><?php echo e(count_category_courses($parent_category->id)); ?></span>
                    </a>
                </li>

                <ul class="entry-widget ms-3 " id="child-category">
                    <?php $__currentLoopData = App\Models\Category::where('parent_id', $parent_category->id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $route_queries['category'] = $child_category->slug; ?>

                        <li class="category <?php if($child_category->slug == $active_category): ?> active <?php endif; ?>"
                            id="<?php echo e($child_category->slug); ?>">
                            <a href="<?php echo e(route('courses', $route_queries)); ?>"
                                class="d-flex align-items-center justify-content-between">
                                <span><?php echo e($child_category->title); ?></span>
                                <span><?php echo e(count_category_courses($child_category->id)); ?></span>
                            </a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
    <!------------------- categories end ------------------->


    <form action="<?php echo e(route('courses', request()->route()->parameter('category'))); ?>" method="get"
        id="filter-courses">

        <?php if(request()->has('search')): ?>
            <input type="hidden" name="search" value="<?php echo e(request()->input('search')); ?>">
        <?php endif; ?>


        <!------------------- price filter start ------------------->
        <div class="widget">
            <h4 class="widget-title"><?php echo e(get_phrase('Price')); ?></h4>
            <ul class="entry-widget">
                <?php $__currentLoopData = ['paid', 'discount', 'free']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="filter-item">
                        <div class="form-check">
                            <input class="form-check-input mt-0" type="radio" name="price"
                                value="<?php echo e($price); ?>" id="price-<?php echo e($price); ?>"
                                <?php if(request()->has('price') && request()->input('price') == $price): ?> checked <?php endif; ?> />
                            <label class="form-check-label"
                                for="price-<?php echo e($price); ?>"><?php echo e(get_phrase(ucfirst($price))); ?></label>
                        </div>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <!------------------- price filter end ------------------->



        <!------------------- level filter start ------------------->
        <div class="widget">
            <h4 class="widget-title"><?php echo e(get_phrase('Level')); ?></h4>
            <ul class="entry-widget">
                <?php $__currentLoopData = ['beginner', 'intermediate', 'advanced']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="filter-item">
                        <div class="form-check">
                            <input class="form-check-input mt-0" type="radio" name="level"
                                value="<?php echo e($level); ?>" id="level-<?php echo e($level); ?>"
                                <?php if(request()->has('level') && request()->input('level') == $level): ?> checked <?php endif; ?> />
                            <label class="form-check-label"
                                for="level-<?php echo e($level); ?>"><?php echo e(get_phrase(ucfirst($level))); ?></label>
                        </div>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <!------------------- level filter end ------------------->



        <!------------------- language filter start ------------------->
        <div class="widget">
            <h4 class="widget-title"><?php echo e(get_phrase('language')); ?></h4>
            <ul class="entry-widget">
                <?php
                    $languages = App\Models\Language::get();
                ?>
                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="filter-item">
                        <div class="form-check">
                            <input class="form-check-input mt-0" type="radio" name="language"
                                value="<?php echo e(slugify($language->name)); ?>" id="language-<?php echo e(slugify($language->name)); ?>"
                                <?php if(request()->has('language') && request()->input('language') == slugify($language->name)): ?> checked <?php endif; ?> />
                            <label class="form-check-label"
                                for="language-<?php echo e(slugify($language->name)); ?>"><?php echo e(get_phrase(ucfirst($language->name))); ?></label>
                        </div>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <!------------------- language filter end ------------------->



        <!------------------- ratings start ------------------->
        <div class="widget">
            <h4 class="widget-title"><?php echo e(get_phrase('Ratings')); ?></h4>
            <ul class="entry-widget">
                <?php for($i = 5; $i >= 1; $i--): ?>
                    <li class="form-check">
                        <input class="form-check-input" type="radio" name="rating" value="<?php echo e($i); ?>"
                            id="raging-<?php echo e($i); ?>" <?php if(request()->has('rating') && request()->input('rating') == $i): ?> checked <?php endif; ?> />
                        <label class="form-check-label" for="raging-<?php echo e($i); ?>">
                            <ul class="d-flex g-star g-5">
                                <?php for($j = 1; $j <= 5; $j++): ?>
                                    <li <?php if($j <= $i): ?> class="color-g" <?php endif; ?>>
                                        <i class="fa fa-star"></i>
                                    </li>
                                <?php endfor; ?>
                            </ul>
                        </label>
                    </li>
                <?php endfor; ?>


            </ul>
        </div>
        <!------------------- ratings end ------------------->
    </form>
</div>


<?php $__env->startPush('js'); ?>
    <script>
        "use strict";
        $(document).ready(function() {
            $('#see-more').on('click', function(e) {
                e.preventDefault();
                $(this).toggleClass('active');
                let show_more = $(this).html();

                if ($(this).hasClass('active')) {
                    $(this).css('margin-top', '20px');
                    $(this).text('<?php echo e(get_phrase('Show Less')); ?>');
                } else {
                    $(this).css('margin-top', '0px');
                    $(this).html('<?php echo e(get_phrase('Show More')); ?>');
                }
            });

            var scrollTop = $(".scrollTop");
            $(scrollTop).on('click', function() {
                $('html, body').animate({
                    scrollTop: 0
                }, 100);
                return false;
            });

            $('input[type="radio"]').change(function(e) {
                $('#filter-courses').trigger('submit');
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /var/www/html/vityarthi.com/resources/views/frontend/default/course/filter.blade.php ENDPATH**/ ?>