<?php
    $faqs = json_decode($course_details->faqs, true);
    $outcomes = json_decode($course_details->outcomes, true);
    $requirements = json_decode($course_details->requirements, true);
?>
<div class="row mb-3">
    <label class="col-md-2 form-label ol-form-label" for="faq"><?php echo e(get_phrase('Course FAQ')); ?></label>
    <div class="col-md-10">
        <div id = "faq_area">
            <?php if(is_array($faqs) && count($faqs) > 0): ?>
                <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="d-flex mt-2">
                    <div class="flex-grow-1 px-3">
                        <div class="form-group">
                            <input type="text" value="<?php echo e($faq['title'] ?? ''); ?>" class="form-control ol-form-control" name="faq_title[]" id="faqs<?php echo e($key ?? ''); ?>" placeholder="<?php echo e(get_phrase('FAQ question')); ?>">
                            <textarea name="faq_description[]" rows="2" class="form-control ol-form-control mt-2" placeholder="<?php echo e(get_phrase('Answer')); ?>"><?php echo e($faq['description'] ?? ''); ?></textarea>
                        </div>
                    </div>
                    <div class="">
                        <?php if($key == 0): ?>
                            <button type="button" class="btn ol-btn-light ol-icon-btn" name="button" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Add new')); ?>" onclick="appendFaq()"> <i class="fi-rr-plus-small"></i> </button>
                        <?php else: ?>
                            <button type="button" class="btn ol-btn-light ol-icon-btn mt-0" name="button" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Remove')); ?>" onclick="removeFaq(this)"> <i class="fi-rr-minus-small"></i> </button>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <div class="d-flex mt-2">
                    <div class="flex-grow-1 px-3">
                        <div class="form-group">
                            <input type="text" class="form-control ol-form-control" name="faq_title[]" id="faqs" placeholder="<?php echo e(get_phrase('FAQ question')); ?>">
                            <textarea name="faq_description[]" rows="2" class="form-control ol-form-control mt-2" placeholder="<?php echo e(get_phrase('Answer')); ?>"></textarea>
                        </div>
                    </div>
                    <div class="">
                        <button type="button" class="btn ol-btn-light ol-icon-btn"  name="button" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Add new')); ?>" onclick="appendFaq()"> <i class="fi-rr-plus-small"></i> </button>
                    </div>
                </div>
            <?php endif; ?>
            <div id = "blank_faq_field">
                <div class="d-flex mt-2">
                    <div class="flex-grow-1 px-3">
                        <div class="form-group">
                            <input type="text" class="form-control ol-form-control" name="faq_title[]" placeholder="<?php echo e(get_phrase('FAQ question')); ?>">
                            <textarea name="faq_description[]" rows="2" class="form-control ol-form-control mt-2" placeholder="<?php echo e(get_phrase('Answer')); ?>"></textarea>
                        </div>
                    </div>
                    <div class="">
                        <button type="button" class="btn ol-btn-light ol-icon-btn mt-0" name="button" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Remove')); ?>" onclick="removeFaq(this)"> <i class="fi-rr-minus-small"></i> </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mb-3 pt-2">
    <label class="col-md-2 form-label ol-form-label" for="requirements"><?php echo e(get_phrase('Requirements')); ?></label>
    <div class="col-md-10">
        <div id = "requirement_area">
            <?php if(is_array($requirements) && count($requirements) > 0): ?>
                <?php $__currentLoopData = $requirements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $requirement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="d-flex mt-2">
                    <div class="flex-grow-1 px-3">
                        <div class="form-group">
                            <input type="text" value="<?php echo e($requirement); ?>" class="form-control ol-form-control" name="requirements[]" id="requirements" placeholder="<?php echo e(get_phrase('Provide requirements')); ?>">
                        </div>
                    </div>
                    <div class="">
                        <?php if($key == 0): ?>
                            <button type="button" class="btn ol-btn-light ol-icon-btn" name="button" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Add new')); ?>" onclick="appendRequirement()"> <i class="fi-rr-plus-small"></i> </button>
                        <?php else: ?>
                            <button type="button" class="btn ol-btn-light ol-icon-btn mt-0" name="button" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Remove')); ?>" onclick="removeRequirement(this)"> <i class="fi-rr-minus-small"></i> </button>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <div class="d-flex mt-2">
                    <div class="flex-grow-1 px-3">
                        <div class="form-group">
                            <input type="text" class="form-control ol-form-control" name="requirements[]" id="requirements" placeholder="<?php echo e(get_phrase('Provide requirements')); ?>">
                        </div>
                    </div>
                    <div class="">
                        <button type="button" class="btn ol-btn-light ol-icon-btn" name="button" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Add new')); ?>" onclick="appendRequirement()"> <i class="fi-rr-plus-small"></i> </button>
                    </div>
                </div>
            <?php endif; ?>
            <div id = "blank_requirement_field">
                <div class="d-flex mt-2">
                    <div class="flex-grow-1 px-3">
                        <div class="form-group">
                            <input type="text" class="form-control ol-form-control" name="requirements[]" id="requirements" placeholder="<?php echo e(get_phrase('Provide requirements')); ?>">
                        </div>
                    </div>
                    <div class="">
                        <button type="button" class="btn ol-btn-light ol-icon-btn mt-0" name="button" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Remove')); ?>" onclick="removeRequirement(this)"> <i class="fi-rr-minus-small"></i> </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mb-3 pt-2">
    <label class="col-md-2 form-label ol-form-label" for="outcomes"><?php echo e(get_phrase('Outcomes')); ?></label>
    <div class="col-md-10">
        <div id = "outcomes_area">
            <?php if(is_array($outcomes) && count($outcomes) > 0): ?>
                <?php $__currentLoopData = $outcomes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $outcome): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="d-flex mt-2">
                    <div class="flex-grow-1 px-3">
                        <div class="form-group">
                            <input type="text" value="<?php echo e($outcome); ?>" class="form-control ol-form-control" name="outcomes[]" id="outcomes" placeholder="<?php echo e(get_phrase('Provide outcomes')); ?>">
                        </div>
                    </div>
                    <div class="">
                        <?php if($key == 0): ?>
                            <button type="button" class="btn ol-btn-light ol-icon-btn" name="button" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Add new')); ?>" onclick="appendOutcome()"> <i class="fi-rr-plus-small"></i> </button>
                        <?php else: ?>
                            <button type="button" class="btn ol-btn-light ol-icon-btn mt-0" name="button" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Remove')); ?>" onclick="removeOutcome(this)"> <i class="fi-rr-minus-small"></i> </button>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <div class="d-flex mt-2">
                    <div class="flex-grow-1 px-3">
                        <div class="form-group">
                            <input type="text" class="form-control ol-form-control" name="outcomes[]" id="outcomes" placeholder="<?php echo e(get_phrase('Provide outcomes')); ?>">
                        </div>
                    </div>
                    <div class="">
                        <button type="button" class="btn ol-btn-light ol-icon-btn" name="button" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Add new')); ?>" onclick="appendOutcome()"> <i class="fi-rr-plus-small"></i> </button>
                    </div>
                </div>
            <?php endif; ?>
            <div id = "blank_outcome_field">
                <div class="d-flex mt-2">
                    <div class="flex-grow-1 px-3">
                        <div class="form-group">
                            <input type="text" class="form-control ol-form-control" name="outcomes[]" placeholder="<?php echo e(get_phrase('Provide outcomes')); ?>">
                        </div>
                    </div>
                    <div class="">
                        <button type="button" class="btn ol-btn-light ol-icon-btn mt-0" name="button" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Remove')); ?>" onclick="removeOutcome(this)"> <i class="fi-rr-minus-small"></i> </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('js'); ?>
	<script type="text/javascript">
		"use strict";

		var blank_faq = jQuery('#blank_faq_field').html();
		var blank_outcome = jQuery('#blank_outcome_field').html();
		var blank_requirement = jQuery('#blank_requirement_field').html();
		jQuery(document).ready(function() {
		  jQuery('#blank_faq_field').hide();
		  jQuery('#blank_outcome_field').hide();
		  jQuery('#blank_requirement_field').hide();
		});

		function appendFaq() {
		  jQuery('#faq_area').append(blank_faq);
		}
		function removeFaq(faqElem) {
		  jQuery(faqElem).parent().parent().remove();
		}

		function appendOutcome() {
		  jQuery('#outcomes_area').append(blank_outcome);
		}
		function removeOutcome(outcomeElem) {
		  jQuery(outcomeElem).parent().parent().remove();
		}

		function appendRequirement() {
		  jQuery('#requirement_area').append(blank_requirement);
		}
		function removeRequirement(requirementElem) {
		  jQuery(requirementElem).parent().parent().remove();
		}

	</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /var/www/html/vityarthi.com/resources/views/admin/course/edit_info.blade.php ENDPATH**/ ?>