<?php
    $quiz = App\Models\Lesson::join('sections', 'lessons.section_id', 'sections.id')
        ->join('courses', 'sections.course_id', 'courses.id')
        ->select('lessons.*', 'courses.id as course_id')
        ->where('lessons.id', $id)
        ->first();

    $duration = $quiz->duration ? explode(':', $quiz->duration) : [];
?>

<form action="<?php echo e(route('admin.course.quiz.update', $id)); ?>" method="post"><?php echo csrf_field(); ?>
    <div class="fpb7 mb-3">
        <label class="form-label ol-form-label" for="title">
            <?php echo e(get_phrase('Title')); ?>

            <span class="text-danger ms-1">*</span>
        </label>
        <input class="form-control ol-form-control" type="text" id="title" name="title" value="<?php echo e($quiz->title); ?>"
            required>
    </div>

    <div class="row mb-3">
        <div class="col-sm-12 fpb-7">
            <label class="form-label ol-form-label">
                <?php echo e(get_phrase('Section')); ?>

                <span class="text-danger ms-1">*</span>
            </label>
            <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="section">
                <option value=""><?php echo e(get_phrase('Select an option')); ?></option>
                <?php $__currentLoopData = App\Models\Section::where('course_id', $quiz->course_id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($section->id); ?>" <?php if($section->id == $quiz->section_id): ?> selected <?php endif; ?>>
                        <?php echo e($section->title); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
    </div>

    <div class="mb-3">
        <label class="form-label ol-form-label" for="duration">
            <?php echo e(get_phrase('Duration')); ?>

            <span class="text-danger ms-1">*</span>
        </label>
        <div class="row">
            <div class="col-4">
                <input class="form-control ol-form-control" type="number" min="0" max="23" name="hour"
                    placeholder="00 hour" value="<?php echo e($duration[0]); ?>">
            </div>
            <div class="col-4">
                <input class="form-control ol-form-control" type="number" min="0" max="59" name="minute"
                    placeholder="00 minute" value="<?php echo e($duration[1]); ?>">
            </div>
            <div class="col-4">
                <input class="form-control ol-form-control" type="number" min="0" max="59" name="second"
                    placeholder="00 second" value="<?php echo e($duration[2]); ?>">
            </div>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-sm-4">
            <label class="form-label ol-form-label" for="total_mark">
                <?php echo e(get_phrase('Total Mark')); ?>

                <span class="text-danger ms-1">*</span>
            </label>
            <input class="form-control ol-form-control" type="number" min="1" id="total_mark" name="total_mark"
                value="<?php echo e($quiz->total_mark); ?>" required>
        </div>
        <div class="col-sm-4">
            <label class="form-label ol-form-label" for="pass_mark">
                <?php echo e(get_phrase('Pass Mark')); ?>

                <span class="text-danger ms-1">*</span>
            </label>
            <input class="form-control ol-form-control" type="number" min="1" id="pass_mark" name="pass_mark"
                value="<?php echo e($quiz->pass_mark); ?>" required>
        </div>
        <div class="col-sm-4">
            <label class="form-label ol-form-label" for="retake">
                <?php echo e(get_phrase('Retake')); ?>

                <span class="text-danger ms-1">*</span>
            </label>
            <input class="form-control ol-form-control" type="number" min="1" id="retake" name="retake"
                value="<?php echo e($quiz->retake); ?>" required>
        </div>
    </div>

    <div class="fpb-7 mb-3">
        <label for="description"
            class="form-label ol-form-label col-form-label"><?php echo e(get_phrase('Description')); ?></label>
        <textarea name="description" rows="5" class="form-control ol-form-control text_editor"><?php echo $quiz->description; ?></textarea>
    </div>

    <div class="fpb7">
        <button type="submit" class="btn ol-btn-primary"><?php echo e(get_phrase('Update Quiz')); ?></button>
    </div>
</form>

<?php echo $__env->make('admin.init', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /var/www/html/vityarthi.com/resources/views/admin/quiz/edit.blade.php ENDPATH**/ ?>