<style>
    .serial {
        width: 30px;
        height: 30px;
        background: #F2F3F5;
        border-radius: 30px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
</style>

<form action="<?php echo e(route('quiz.submit', $quiz->id)); ?>" method="post" class="quiz-submit-form"><?php echo csrf_field(); ?>
    <input type="hidden" name="quiz_id" value="<?php echo e($quiz->id); ?>">
    <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="question px-4 mb-4 <?php if($key > 0): ?> d-none <?php endif; ?>">
            <div class="mb-3 d-flex gap-3">
                <span class="serial"><?php echo e(++$key); ?> </span>
                <div><?php echo $question->title; ?></div>
            </div>

            <div class="row gap-0">
                <?php if($question->type == 'mcq'): ?>
                    <?php $options = json_decode($question->options, true) ?? []; ?>
                    <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-sm-6">
                            <input class="form-check-input" type="checkbox" name="<?php echo e($question->id); ?>[]"
                                value="<?php echo e($option); ?>" id="<?php echo e($option); ?>-<?php echo e($question->id); ?>">
                            <label class="form-check-label text-capitalize"
                                for="<?php echo e($option); ?>-<?php echo e($question->id); ?>"><?php echo e($option); ?></label>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php elseif($question->type == 'fill_blanks'): ?>
                    <input type="text" class="form-control tagify" name="<?php echo e($question->id); ?>" data-role="tagsinput">
                <?php elseif($question->type == 'true_false'): ?>
                    <div class="col-sm-2">
                        <input class="form-check-input" type="radio" name="<?php echo e($question->id); ?>" value="true"
                            id="question-<?php echo e($question->id); ?>-true">
                        <label class="form-check-label"
                            for="question-<?php echo e($question->id); ?>-true"><?php echo e(get_phrase('True')); ?></label>
                    </div>
                    <div class="col-sm-2">
                        <input class="form-check-input" type="radio" name="<?php echo e($question->id); ?>" value="false"
                            id="question-<?php echo e($question->id); ?>-false">
                        <label class="form-check-label"
                            for="question-<?php echo e($question->id); ?>-false"><?php echo e(get_phrase('False')); ?></label>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</form>


<?php if($questions->count() > 0): ?>
    <div class="row">
        <div class="col-12 d-flex gap-3 justify-content-center">
            <button type="button" class="eBtn gradient border-0" id="prevBtn" onclick="prevQuestion()"><i
                    class="fi fi-rr-angle-small-left"></i><?php echo e(get_phrase('Prev')); ?></button>
            <button type="button" class="eBtn gradient border-0" id="nextBtn"
                onclick="nextQuestion()"><?php echo e(get_phrase('Next')); ?><i class="fi fi-rr-angle-small-right"></i></button>
            <?php if($submits->count() < $quiz->retake): ?>
                <button type="button" class="eBtn gradient border-0 d-none" id="submitBtn"
                    onclick="submitQuiz()"><?php echo e(get_phrase('Submit')); ?><i class="fi fi-rr-badge-check ms-2"></i></button>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>

<?php echo $__env->make('course_player.init', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
    let nextBtn = document.querySelector('#nextBtn');
    let prevBtn = document.querySelector('#prevBtn');
    let submitBtn = document.querySelector('#submitBtn');
    let submitForm = document.querySelector('.quiz-submit-form');
    // next question
    function nextQuestion() {
        let selectQuestion = document.querySelector('.question:not(.d-none)');
        let nextQuestion = selectQuestion.nextElementSibling;
        if (nextQuestion && nextQuestion.classList.contains('question')) {
            selectQuestion.classList.add('d-none');
            nextQuestion.classList.remove('d-none');
        }
        let nextNextQuestion = nextQuestion.nextElementSibling;
        if (!(nextNextQuestion && nextNextQuestion.classList.contains('question'))) {
            submitBtn.classList.remove('d-none');
            nextBtn.classList.add('d-none');
        }
    }

    // previous question
    function prevQuestion() {
        let selectQuestion = document.querySelector('.question:not(.d-none)');
        let prevQuestion = selectQuestion.previousElementSibling;
        if (prevQuestion && prevQuestion.classList.contains('question')) {
            selectQuestion.classList.add('d-none');
            prevQuestion.classList.remove('d-none');
        }
        if (nextBtn.classList.contains('d-none')) {
            nextBtn.classList.remove('d-none');
            submitBtn.classList.add('d-none');
        }
    }

    // submit quiz
    function submitQuiz() {
        submitForm.submit();
    }
</script>
<?php /**PATH /var/www/html/vityarthi.com/resources/views/course_player/quiz/questions.blade.php ENDPATH**/ ?>