<div class="gradient-border radius-22 page-static-sidebar">
    <div class="ps-box ps-sidebar">
        <div class="hero-details position-relative pt-3 pb-4 mt-0">
            <img class="radius-10" src="<?php echo e(get_image($course_details->banner)); ?>" alt="...">
            <div class="overly-icon" data-bs-toggle="modal" data-bs-target="#exampleModal">
                <a href="javascript:;" class="hero-popup"><i class="fa-solid fa-play"></i></a>
            </div>
        </div>

        <?php if($course_details->is_best): ?>
            <span class="d-inline-flex justify-content-center trophy-text w-100 px-2 py-1">
                <img src="<?php echo e(asset('assets/frontend/default/image/best-seller.svg')); ?>" alt="best-seller-icon"><?php echo e(get_phrase('Top course')); ?></span>
        <?php endif; ?>

        <div class="ps-price d-flex">
            <?php if(isset($course_details->is_paid) && $course_details->is_paid == 0): ?>
                <h4 class="g-title"><?php echo e(get_phrase('Free')); ?></h4>
            <?php elseif(isset($course_details->discount_flag) && $course_details->discount_flag == 1): ?>
                <h4 class="g-title">
                    <?php echo e(currency($course_details->discounted_price, 2)); ?></h4>
                <del><?php echo e(currency($course_details->price, 2)); ?></del>
            <?php else: ?>
                <h4 class="g-title"><?php echo e(currency($course_details->price, 2)); ?></h4>
            <?php endif; ?>
        </div>

        <?php
            if (isset(auth()->user()->id)) {
                $is_enrolled = DB::table('enrollments')
                    ->where('user_id', auth()->user()->id)
                    ->where('course_id', $course_details->id)
                    ->where(function ($query) {
                        $query->where('expiry_date', '>', now()->timestamp)
                            ->orWhereNull('expiry_date');
                    })
                    ->exists();

                $in_cart = DB::table('cart_items')
                    ->where('user_id', auth()->user()->id)
                    ->where('course_id', $course_details->id)
                    ->exists();

                $in_wishlist = DB::table('wishlists')
                    ->where('user_id', auth()->user()->id)
                    ->where('course_id', $course_details->id)
                    ->exists();

                $pending_course_for_payment = DB::table('offline_payments')
                    ->where('user_id', auth()->user()->id)
                    ->where('status', 0)
                    ->first();

                $pending_course = $pending_course_for_payment ? json_decode($pending_course_for_payment->items, true) : [];
            }
        ?>

        <?php if(isset(auth()->user()->id)): ?>
            <?php if(in_array($course_details->id, $pending_course)): ?>
                <a href="javascript::void(0);" class="eBtn gradient w-100 mb-3">
                    <img src="<?php echo e(asset('assets/frontend/default/image/enroll.png')); ?>" alt="...">
                    <?php echo e(get_phrase('In progress')); ?></a>
            <?php else: ?>
                <?php if($is_enrolled): ?>
                    <a href="<?php echo e(route('my.courses')); ?>" class="eBtn gradient w-100 mb-3">
                        <img src="<?php echo e(asset('assets/frontend/default/image/enroll.png')); ?>" alt="...">
                        <?php echo e(get_phrase('Start Now')); ?></a>
                <?php else: ?>
                    <a href="<?php echo e(route('purchase.course', $course_details->id)); ?>" class="eBtn gradient w-100">
                        <img src="<?php echo e(asset('assets/frontend/default/image/enroll.png')); ?>" alt="...">
                        <?php echo e(get_phrase($course_details->is_paid ? get_phrase('Buy Now') : get_phrase('Enroll Now'))); ?>

                    </a>

                    <?php if(isset($course_details->is_paid) && $course_details->is_paid == 1): ?>
                        <?php if($in_cart): ?>
                            <a href="<?php echo e(route('cart.delete', ['id' => $course_details->id])); ?>" class="eBtn mt-3 gradient w-100">
                                <?php echo e(get_phrase('Remove from cart')); ?></a>
                        <?php else: ?>
                            <a href="<?php echo e(route('cart.store', $course_details->id)); ?>" class="eBtn learn-btn w-100 mb-3 mt-3">
                                <?php echo e(get_phrase('Add to cart')); ?></a>
                        <?php endif; ?>
                    <?php endif; ?>

                    <?php if($in_wishlist): ?>
                        <span class="eBtn border gradient w-100 cursor-pointer mt-3 toggleWishItem" onclick="wishlistToggleButton('<?php echo e($course_details->id); ?>', this)">
                            <?php echo e(get_phrase('Remove from wishlist')); ?>

                        </span>
                    <?php else: ?>
                        <span class="eBtn border learn-btn w-100 cursor-pointer mt-3 toggleWishItem mb-0" onclick="wishlistToggleButton('<?php echo e($course_details->id); ?>', this)">
                            <?php echo e(get_phrase('Add to wishlist')); ?></span>
                    <?php endif; ?>
                <?php endif; ?>
            <?php endif; ?>
        <?php else: ?>
            <a href="<?php echo e(route('purchase.course', $course_details->id)); ?>" class="eBtn gradient mt-3 w-100">
                <img src="<?php echo e(asset('assets/frontend/default/image/enroll.png')); ?>" alt="...">
                <?php echo e(get_phrase($course_details->is_paid ? get_phrase('Buy Now') : get_phrase('Enroll Now'))); ?></a>
        <?php endif; ?>


        <ul class="ps-side-feature mt-2">
            <li class="d-flex justify-content-between align-items-center py-3 mb-0">
                <span>
                    <img src="<?php echo e(asset('assets/frontend/default/image/m1.png')); ?>" alt="...">
                    <p><?php echo e(get_phrase('Students')); ?></p>
                </span>
                <?php echo e(total_enroll($course_details->id)); ?>

            </li>
            <li class="d-flex justify-content-between align-items-center py-3 mb-0">
                <span>
                    <img src="<?php echo e(asset('assets/frontend/default/image/language2.png')); ?>" alt="...">
                    <p><?php echo e(get_phrase('Language')); ?></p>
                </span>
                <?php echo e(ucfirst($course_details->language)); ?>

            </li>
            <li class="d-flex justify-content-between align-items-center py-3 mb-0">
                <span>
                    <img src="<?php echo e(asset('assets/frontend/default/image/time.png')); ?>" alt="...">
                    <p><?php echo e(get_phrase('Duration')); ?></p>
                </span>
                <?php echo e(total_durations($course_details->id)); ?>

            </li>
            <li class="d-flex justify-content-between align-items-center py-3 mb-0">
                <span>
                    <i class="fi fi-rr-dashboard"></i>
                    <p><?php echo e(get_phrase('Level')); ?></p>
                </span>
                <?php echo e($course_details->level); ?>

            </li>
            <li class="d-flex justify-content-between align-items-center py-3 mb-0">
                <span>
                    <img src="<?php echo e(asset('assets/frontend/default/image/expired.svg')); ?>" alt="...">
                    <p><?php echo e(get_phrase('Expiry period')); ?></p>
                </span>
                <?php echo e($course_details->expiry_period <= 0 ? get_phrase('Lifetime') : $course_details->expiry_period.' '.get_phrase('Months')); ?>

            </li><li class="d-flex justify-content-between align-items-center py-3 mb-0">
                <span>
                    <img src="<?php echo e(asset('assets/frontend/default/image/certificate.svg')); ?>" alt="...">
                    <p><?php echo e(get_phrase('Certificate')); ?></p>
                </span>
                <?php echo e(get_phrase('yes')); ?>

            </li>
        </ul>

        <?php
            if (isset($user_data['unique_identifier'])):
                $ref = $user_data['unique_identifier'];
            else:
                $ref = '';
            endif;
            $share_url = route('course.details', $course_details->slug);
        ?>
        <div class="w-100 px-4 pb-2 text-center mt-3">
            <span><?php echo e(get_phrase('Share')); ?> :</span>
            <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e($share_url); ?>&ref=<?php echo e($ref); ?>" target="_blank" class="p-2 mx-2 color-facebook" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Share on Facebook')); ?>" data-bs-placement="top">
                <i class="fab fa-facebook text-20"></i>
            </a>
            <a href="https://twitter.com/intent/tweet?url=<?php echo e($share_url); ?>&text=<?php echo e($course_details['title']); ?>&ref=<?php echo e($ref); ?>" target="_blank" class="p-2 mx-2 color-twitter" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Share on Twitter')); ?>" data-bs-placement="top">
                <i class="fab fa-twitter text-20"></i>
            </a>
            <a href="https://api.whatsapp.com/send?text=<?php echo e($share_url); ?>&ref=<?php echo e($ref); ?>" target="_blank" class="p-2 mx-2 color-whatsapp" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Share on Whatsapp')); ?>" data-bs-placement="top">
                <i class="fab fa-whatsapp text-20"></i>
            </a>
            <a href="https://www.linkedin.com/shareArticle?url=<?php echo e($share_url); ?>&title=<?php echo e($course_details['title']); ?>&summary=<?php echo e($course_details['short_description']); ?>&ref=<?php echo e($ref); ?>" target="_blank" class="p-2 mx-2 color-linkedin" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Share on Linkedin')); ?>" data-bs-placement="top">
                <i class="fab fa-linkedin text-20"></i>
            </a>
        </div>
    </div>
</div>

<script>
    'use strict';

    function wishlistToggleButton(course_id, elem) {
        $.ajax({
            type: "get",
            url: "<?php echo e(route('toggleWishItem')); ?>" + '/' + course_id,
            success: function(response) {
                if (response) {
                    if (response.toggleStatus == 'added') {
                        $(elem).removeClass('learn-btn');
                        $(elem).addClass('gradient');
                        $(elem).html('<?php echo e(get_phrase('Remove from wishlist')); ?>');
                    } else if (response.toggleStatus == 'removed') {
                        $(elem).removeClass('gradient');
                        $(elem).addClass('learn-btn');
                        $(elem).html('<?php echo e(get_phrase('Add to wishlist')); ?>');
                    }
                }
            }
        });
    }
</script>

<?php echo $__env->make('frontend.default.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /var/www/html/vityarthi.com/resources/views/frontend/default/course/pricing_card.blade.php ENDPATH**/ ?>