<?php $__env->startPush('title', get_phrase('Instructors')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?><?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <!------------------- Breadcum Area Start  ------>
    <section class="breadcum-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="eNtry-breadcum">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(get_phrase('Home')); ?></a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php echo e(get_phrase('Instructors')); ?></li>
                            </ol>
                        </nav>
                        <h3 class="g-title"><?php echo e(get_phrase('Instructors')); ?></h3>
                    </div>
                </div>
            </div>
            <p class="showing-text mt-15"><?php echo e(get_phrase('Learn to train with the best personal trainer')); ?></p>
        </div>
    </section>
    <!------------------- Breadcum Area End  --------->
    <!-------------- List Item Start   --------------->
    <div class="eNtery-item entry_instuctor">
        <div class="container">
            <div class="row mt-25 justify-content-center">
                <?php $__currentLoopData = $instructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-3 col-md-4 col-sm-6 mb-30">
                        <a href="<?php echo e(route('instructor.details', ['name' => slugify($instructor->name), 'id' => $instructor->id])); ?>"
                            class="card Ecard eCard2">
                            <div class="card-head radius-10">
                                <img class="radius-10" src="<?php echo e(get_image($instructor->photo)); ?>" alt="instructor-photo">
                            </div>
                            <div class="card-body entry-details text-center mt-0 pb-0">
                                <h4><?php echo e(ucfirst($instructor->name)); ?></h4>
                                <span class="gradient color shadow-none">
                                    <?php echo e($instructor->skills ? implode(', ', array_column(json_decode($instructor->skills, true), 'value')) : ''); ?>

                                </span>
                                <p class="mt-0"><?php echo e($instructor->email); ?></p>
                            </div>
                        </a>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Pagination -->
            <?php if(count($instructors) > 0): ?>
                <div class="entry-pagination">
                    <nav aria-label="Page navigation example">
                        <?php echo e($instructors->links()); ?>

                    </nav>
                </div>
            <?php endif; ?>
            <!-- Pagination -->
        </div>
    </div>
    <!-------------- List Item End  --------------->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/vityarthi.com/resources/views/frontend/default/instructor/index.blade.php ENDPATH**/ ?>