<?php $__env->startPush('title', get_phrase('My Team Packages')); ?>
<?php $__env->startSection('content'); ?>
    <section class="my-course-content mt-50">
        <div class="profile-banner-area"></div>
        <div class="profile-banner-area-container container">
            <div class="row">
                <?php echo $__env->make('frontend.default.student.left_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="col-lg-9">
                    <h4 class="g-title text-capitalize"><?php echo e(get_phrase('My Team Packages')); ?></h4>
                    <div class="my-panel mt-5">
                        <div class="row">
                            <?php if(count($packages) > 0): ?>
                                <ul class="my-bootcamps">
                                    <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="p-0" id="package-<?php echo e($package->id); ?>">
                                            <a href="<?php echo e(route('my.team.packages.details', $package->slug)); ?>" class="bootcamp d-block">
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <div class="package-thumbnail mb-md-0 mb-3">
                                                            <img src="<?php echo e(get_image($package->thumbnail)); ?>">
                                                        </div>
                                                    </div>

                                                    <div class="col-md-9">
                                                        <div class="bootcamp-details">
                                                            <div class="inner">
                                                                <h4 class="bootcamp-title mb-2" data-bs-toggle="tooltip" data-bs-placement="bottom" title="<?php echo e($package->title); ?>">
                                                                    <span class="ellipsis-2"><?php echo e($package->title); ?></span>
                                                                    <i class="fi fi-br-angle-small-right"></i>
                                                                </h4>

                                                                <p class="fs-4 ellipsis-2">
                                                                    <?php echo e(get_phrase('Course : ')); ?>

                                                                    <?php echo e($package->course_title); ?>

                                                                </p>


                                                                <p class="d-inline-block me-4">
                                                                    <?php echo e(get_phrase('Expiry : ')); ?>

                                                                    <?php if($package->expiry == 'lifetime'): ?>
                                                                        <?php echo e(get_phrase('Lifetime')); ?>

                                                                    <?php else: ?>
                                                                        <?php echo e(date('d-M-Y', $package->expiry_date)); ?>

                                                                    <?php endif; ?>
                                                                </p>

                                                                <p class="d-inline-block me-4">
                                                                    <?php echo e(get_phrase('Members : ')); ?>

                                                                    <?php echo e($package->allocation); ?> /
                                                                    <?php echo e(reserved_team_members($package->id)); ?>

                                                                </p>

                                                                <p class="d-inline-block me-4">
                                                                    <?php echo e(get_phrase('Sections : ')); ?>

                                                                    <?php echo e(section_count($package->course_id)); ?>

                                                                </p>

                                                                <p class="d-inline-block me-4">
                                                                    <?php echo e(get_phrase('Lessons : ')); ?>

                                                                    <?php echo e(lesson_count($package->course_id)); ?>

                                                                </p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php else: ?>
                                <?php echo $__env->make('frontend.default.empty', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Pagination -->
            <?php if(count($packages) > 0): ?>
                <div class="entry-pagination">
                    <nav aria-label="Page navigation example">
                        <?php echo e($packages->links()); ?>

                    </nav>
                </div>
            <?php endif; ?>
            <!-- Pagination -->
        </div>
    </section>
    <!------------ My wishlist area End  ------------>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/vityarthi.com/resources/views/frontend/default/student/my_team_packages/index.blade.php ENDPATH**/ ?>